/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm8275;

import ibm.nways.jdm.DestinationPropBook;
import ibm.nways.jdm.JdmBrowser;
import ibm.nways.jdm.NavigationContext;
import ibm.nways.jdm.common.ModelInfo;
import ibm.nways.jdm.common.SpecialValue;
import ibm.nways.jdm.common.Timeout;
import ibm.nways.jdm.eui.JDMWizardInfo;
import ibm.nways.jdm.eui.JDMWizardPanelDelegate;
import ibm.nways.jdm.eui.MessageBox;
import ibm.nways.jdm.modelgen.GenModel;
import ibm.nways.jdm8275.BoxInfo;
import ibm.nways.ras.RAS;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.ResourceBundle;

public class VlanDelete
implements JDMWizardPanelDelegate {
    private static ResourceBundle myResources = ResourceBundle.getBundle("ibm.nways.jdm8275.GeneralResources");
    private static final int RASID = 19;
    private static final int RASSUB = 7;
    DestinationPropBook myBook;
    JdmBrowser browser;
    NavigationContext myContext;
    BoxInfo boxInfo;
    MessageBox messageToUser;
    boolean noErrors = true;
    Serializable vlan;
    Serializable vlanNameString;
    Serializable vlanAttribute;
    String errorMsg;

    public void setDefaults(JDMWizardInfo jDMWizardInfo) {
        String string = "setDefaults";
        this.noErrors = true;
        this.myBook = (DestinationPropBook)jDMWizardInfo.getPropertyBook();
        if (this.browser == null && this.myBook != null) {
            this.browser = (JdmBrowser)this.myBook.getBrowser();
        }
        if (this.browser == null) {
            if (RAS.isEnabled(19, 7)) {
                RAS.trace(19, 7, this, string, "can't get browser- abort delete");
            }
            this.noErrors = false;
        }
        if (this.noErrors) {
            ModelInfo modelInfo = jDMWizardInfo.getCurrentRow();
            Hashtable hashtable = jDMWizardInfo.getItems();
            if (modelInfo == null) {
                if (RAS.isEnabled(19, 7)) {
                    RAS.trace(19, 7, this, string, "empty row selected");
                }
                this.errorMsg = new String("WZ_emptyRow");
                this.noErrors = false;
            } else {
                this.vlan = modelInfo.get("Index.Vlan");
                this.vlanNameString = modelInfo.get("Panel.VlanNameString");
                this.vlanAttribute = modelInfo.get("Panel.VlanAttribute");
                hashtable.put("deleteVlan", this.vlan);
                hashtable.put("deleteVlanNameString", this.vlanNameString);
                hashtable.put("deleteVlanAttribute", this.vlanAttribute);
                if (this.vlan instanceof SpecialValue || this.vlanAttribute instanceof SpecialValue) {
                    if (RAS.isEnabled(19, 7)) {
                        RAS.trace(19, 7, this, string, "vlan id has specialValue = " + this.vlan);
                    }
                    this.errorMsg = new String("WZ_invalidVlan");
                    this.noErrors = false;
                } else if ((Integer)this.vlanAttribute != 1) {
                    if (RAS.isEnabled(19, 7)) {
                        RAS.trace(19, 7, this, string, "vlan" + this.vlan + " is dynamic - can't delete");
                    }
                    this.errorMsg = new String("VD_dynamicVlan");
                    this.noErrors = false;
                }
            }
        }
        if (!this.noErrors && this.browser != null) {
            this.browser.displayMsg(this.getNLSString(this.errorMsg));
            this.messageToUser = new MessageBox(this.browser.getFrame(), this.getNLSString("VD_error"), this.getNLSString(this.errorMsg), true);
            return;
        }
        if (this.browser != null) {
            this.browser.displayMsg(this.getNLSString("WZ_deleteConfirm"));
        }
    }

    public boolean abort(JDMWizardInfo jDMWizardInfo) {
        return true;
    }

    public boolean proceed(JDMWizardInfo jDMWizardInfo) {
        String string = "proceed";
        GenModel genModel = null;
        ModelInfo modelInfo = null;
        if (this.noErrors) {
            if (RAS.isEnabled(19, 7)) {
                RAS.trace(19, 7, this, string, "Entry.");
            }
            genModel = jDMWizardInfo.getModel();
            modelInfo = new ModelInfo();
            modelInfo.add("Index.Vlan", this.vlan);
            modelInfo.add("Panel.VlanStatus", new Integer(2));
            try {
                modelInfo = genModel.setInfo("Panel", modelInfo);
                Serializable serializable = modelInfo.get("Panel.VlanStatus");
                if (serializable instanceof SpecialValue) {
                    if (RAS.isEnabled(19, 7)) {
                        RAS.trace(19, 7, this, string, "Vlan delete for id = " + this.vlan + " returned special Value = " + serializable);
                    }
                    this.errorMsg = serializable instanceof Timeout ? new String("WZ_badSetTimeout") : new String("WZ_rejectDelete");
                    this.noErrors = false;
                }
            }
            catch (Exception exception) {
                this.noErrors = false;
                this.errorMsg = new String("WZ_badSet");
                RAS.logError(19, 7, this, string, "EXCEPTION_SETTING_MODELINFO", (Object)modelInfo, (Object)"VlanModel");
                RAS.logException(19, 7, this, string, exception);
            }
        }
        if (!this.noErrors && this.browser != null) {
            this.browser.displayMsg(this.getNLSString(this.errorMsg));
            this.messageToUser = new MessageBox(this.browser.getFrame(), this.getNLSString("VD_error"), this.getNLSString(this.errorMsg), true);
        } else if (this.browser != null) {
            this.browser.displayMsg(this.getNLSString("WZ_deleteDone"));
        }
        return this.noErrors;
    }

    protected String getNLSString(String string) {
        String string2 = "getNLSString";
        String string3 = null;
        try {
            string3 = myResources.getString(string);
        }
        catch (Exception exception) {
            RAS.logError(19, 7, this, string2, "EXCEPTION_ACCESSING_MODELINFO", (Object)"ibm.nways.jdm8275.GeneralResources", (Object)string);
            string3 = string;
        }
        return string3;
    }
}

